<?php
/**
 * Header Tab For Theme Option.
 *
 * @package bim
 */

// Font options for family. size and fully typography.

if ( ! function_exists( 'bim_enqueue_fonts_url' ) ) :

function bim_enqueue_fonts_url() {
    $bim_fonts_url = '';
    $bim_fonts     = array();
    $bim_main_font_weight = array();
    $bim_alt_font_weight = array();
    $bim_font_subsets = array();
    global $bim_theme_settings;
    
    /* For Main Font Weight */
    $bim_main_font_weight_array = ( isset( $bim_theme_settings['main_font_weight'] ) ) ? $bim_theme_settings['main_font_weight'] : '';
    if( !empty( $bim_main_font_weight_array ) ) {
        foreach ($bim_main_font_weight_array as $key => $value) {
            if( $value == 1 ){
                $bim_main_font_weight[] = $key;
            }
        }
    }

    if( !empty( $bim_main_font_weight ) ) {
        $bim_main_font_weight = implode( ',', $bim_main_font_weight );
    } else {
        $bim_main_font_weight = '100,300,400,500,700,900';
    }

    if( bim_option('main_font')){ 
        $bim_fonts[] = $bim_theme_settings['main_font']['font-family'].':'.$bim_main_font_weight;
    }else{
        $bim_fonts[] = 'Roboto:100,300,400,500,700,900';
    }

    /* For Alt Font Weight */
    $bim_alt_font_weight_array = ( isset( $bim_theme_settings['alt_font_weight'] ) ) ? $bim_theme_settings['alt_font_weight'] : '';
    if( !empty( $bim_alt_font_weight_array ) ) {
        foreach ($bim_alt_font_weight_array as $key => $value) {
            if( $value == 1 ){
                $bim_alt_font_weight[] = $key;
            }
        }
    }

    if( !empty( $bim_alt_font_weight ) ) {
        $bim_alt_font_weight = implode( ',', $bim_alt_font_weight );
    } else {
        $bim_alt_font_weight = '100,200,300,400,500,600,700,800,900';
    }
    if( bim_option('alt_font')){
        $bim_fonts[] = $bim_theme_settings['alt_font']['font-family'].':'.$bim_alt_font_weight;
    }else{
        $bim_fonts[] = 'Montserrat:100,200,300,400,500,600,700,800,900';
    }

    /* For Font Subsets */
    $bim_main_font_subsets = ( isset( $bim_theme_settings['main_font_languages'] ) ) ? $bim_theme_settings['main_font_languages'] : '' ;
    if( !empty( $bim_main_font_subsets ) ) {
        foreach ($bim_main_font_subsets as $key => $value) {
            if( $value == 1 ){
                $bim_font_subsets[] = $key;
            }
        }
    }
    if( !empty( $bim_font_subsets ) ) {
        $bim_main_font_subsets = implode( ',',  $bim_font_subsets );
    } else {
        $bim_main_font_subsets = '';
    }

    if ( $bim_fonts ) {
        $bim_fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $bim_fonts ) ),
            'subset' => urlencode( $bim_main_font_subsets ),
        ), '//fonts.googleapis.com/css' );
    }
    return $bim_fonts_url;
}
endif;

if ( ! function_exists( 'bim_font_scripts' ) ) :
    function bim_font_scripts() {
        $disable_google_fonts = bim_option( 'disable_google_fonts' );
        if( $disable_google_fonts != 1 ) {
            wp_enqueue_style( 'bim-fonts', bim_enqueue_fonts_url(), array(), null );
        }
    }
endif;
add_action( 'wp_enqueue_scripts', 'bim_font_scripts' );

?>