<?php
namespace BimPlugin\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


		
/**
 * @since 1.0.0
 */
class Bim_Menu_Float extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bim-menu-float';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Bim Menu Float', 'bim_plg' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-person';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bim-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
	
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Featured Settings', 'bim_plg' ),
			]
		);
		
		
		$this->add_control(
            'main_icon',
            [
                'label' => __( 'Featured Image', 'bim_plg' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'fas fa-list',
            ]
        );
		
		
		
		 
		$this->add_control(
			'featured_icon',
			[
				'label' => __( 'Featured Social Icon', 'bim_plg' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'icon' => 'fa fa-download',
					],
					[
						'icon' => 'fa fa-book',
					],
					[
						'icon' => 'fa fa-angle-double-right',
					],
				],
				'fields' => [
					[
						'name' => 'link',
						'label' => __( 'Icon link', 'bim_plg' ),
						'type' => Controls_Manager::URL,
						'label_block' => true,
						'placeholder' => __( 'Your icon link..', 'bim_plg' ),
					],
					[
						'name' => 'mention',
						'label' => __( 'Mention', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'default' => __( 'Mention', 'bim_plg' ),
						'label_block' => true,
					],
					
					[
						'name' => 'icon',
						'label' => __( 'Icon', 'bim_plg' ),
						'type' => Controls_Manager::ICON,
						'label_block' => true,
						'default' => 'fa fa-download',
					],
				],
				'title_field' => '<i class="{{ icon }}"></i> {{{ icon.replace( \'fa fa-\',\'\' ).replace( \'-\',\' \' ).replace( /\b\w/g, function( letter ){ return letter.toUpperCase() } ) }}}',
			]
		);
		
		
		$this->end_controls_section();
		

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() { 
	$settings = $this->get_settings();
	$this->add_inline_editing_attributes( 'title' );
	$this->add_inline_editing_attributes( 'text' );
	
	?>
        

         <!-- =====================================
        ==== Start Featured -->

        <div class="menu-float">
            <div class="item">

                <div class="info">
                    <div>
		                    <a href='#0' class="icon main-icon">
							<i class="<?php echo esc_attr ( $settings['main_icon']); ?>"></i> 
							</a>
		                 	     <?php foreach ( $settings['featured_icon'] as $index => $item ) : 
		                        $link_key = 'link_' . $index;
		                        $this->add_render_attribute( $link_key, 'href',esc_url ($item['link']['url']) );

		                        if ( $item['link']['is_external'] ) {
		                            $this->add_render_attribute( $link_key, 'target', '_blank' );
		                        }

		                        if ( $item['link']['nofollow'] ) {
		                            $this->add_render_attribute( $link_key, 'rel', 'nofollow' );
		                        }
		                        ?>
		                    <a href='<?php echo $item['link']['url'] ?>' class="icon sub-icon">
		                        <i class="<?php echo esc_attr ( $item['icon']); ?> "></i> 
		                        <?php if(! empty( $item['mention'])){ ?>
		                        <div class="icon-text"><?php echo $item['mention']; ?></div>
		                   		 <?php } ?>
		                    </a>
		                    <?php endforeach; ?>

                       
                    </div>
                </div>
            </div>
        </div>

        <!-- End Featureds ====
        ======================================= -->
             
	<?php 

	
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		
		
	}
}


