<?php
namespace BimPlugin;

use BimPlugin\Widgets\Dsc_Slider;
use BimPlugin\Widgets\Bim_Logo;
use BimPlugin\Widgets\Bim_Menu;
use BimPlugin\Widgets\Bim_Menu_Float;
use BimPlugin\Widgets\Bim_Header_Search;
use BimPlugin\Widgets\Bim_Portfolio;
use BimPlugin\Widgets\Bim_Product;
use BimPlugin\Widgets\Bim_Title;
use BimPlugin\Widgets\Bim_Countdown;
use BimPlugin\Widgets\Bim_Team;
use BimPlugin\Widgets\Bim_Fancy;
use BimPlugin\Widgets\Bim_Testimonial;
use BimPlugin\Widgets\Bim_TextIcon;
use BimPlugin\Widgets\Bim_ImageBox;
use BimPlugin\Widgets\Bim_WorkProcess;
use BimPlugin\Widgets\Bim_ImageBoxSlider;
use BimPlugin\Widgets\Bim_ImageComparisonSlider;
use BimPlugin\Widgets\Bim_Featured;
// use BimPlugin\Widgets\Bim_Flip_Box;
use BimPlugin\Widgets\Bim_Post;
use BimPlugin\Widgets\Bim_Post_Two;
use BimPlugin\Widgets\Bim_Post_Three;
use BimPlugin\Widgets\Bim_Contact;
use BimPlugin\Widgets\Bim_Offcanvas;




if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class BimPlugin {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {
		//register all script 
		add_action( 'elementor/widgets/register',[ $this, 'on_widgets_registered' ] );
		//isotope script
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('jquery-isotope',BIM_URL .'widgets/js/isotope.pkgd.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-portfolio',BIM_URL .'widgets/js/portfolio.js', array('jquery'), null, true  );} );
		//blog masonry script
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-blog-masonry',BIM_URL .'widgets/js/blog-mason.js', array('jquery'), null, true  );} ); 
		//slider script
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('jquery-slick',BIM_URL .'widgets/js/slick.min.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('jquery-swiper',BIM_URL .'widgets/js/swiper.min.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-animation',BIM_URL .'widgets/js/slick-animation.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-slider-script',BIM_URL .'widgets/js/slider.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-swiper-slider-script',BIM_URL .'widgets/js/slider-swiper.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-imgbox-slider',BIM_URL .'widgets/js/imgbox-slider.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-image-comparison-slider',BIM_URL .'widgets/js/image-comparison-slider.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-work-process',BIM_URL .'widgets/js/work-process.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-blog-slider-script',BIM_URL .'widgets/js/blog-slider.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('prefixfree',BIM_URL .'widgets/js/prefixfree.min.js', array('jquery'), null, true  );} );
		//gallery popup
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('jquery-magnificpopup',BIM_URL .'widgets/js/jquery.magnific-popup.min.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-gallery-popup',BIM_URL .'widgets/js/popup-gallery.js', array('jquery'), null, true  );} );
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-blog-script',BIM_URL .'widgets/js/blog.js', array('jquery'), null, true  );} );
		
		//gallery  masonry
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-masonry-gallery',BIM_URL .'widgets/js/mason-gallery.js', array('jquery'), null, true  );} );
		
		//share script
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-share',BIM_URL .'widgets/js/share.js', array('jquery'), null, true  );} );
		
		//testmonial
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-testimonial',BIM_URL .'widgets/js/testimonial.js', array('jquery'), null, true  );} );
		//Header search
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-header-search',BIM_URL .'widgets/js/header-search.js', array('jquery'), null, true  );} );
		//Header Offcanvas
		add_action( 'elementor/frontend/after_register_scripts', function() {  wp_register_script('bim-header-offcanvas',BIM_URL .'widgets/js/header-offcanvas.js', array('jquery'), null, true  );} );

		add_action( 'wp_enqueue_scripts', function() {wp_enqueue_style('bim-plugin-style', BIM_URL . 'widgets/css/style.css', array(), '1.0.0', 'all');} );
          // Slick responsive
		// add_action( 'wp_enqueue_scripts', function() {wp_enqueue_script( 'slick-slider-core' ); wp_enqueue_style( 'slick-slider-core-theme' );}, 11 );
		// add_action( 'wp_enqueue_scripts', function() {wp_deregister_script( 'slick-slider-core' ); wp_deregister_style( 'slick-slider-core-theme' );} , 11); 

		
		// //Styles
		// add_action( 'elementor/frontend/after_enqueue_styles', function() {  wp_enqueue_style('bim-style-addons',BIM_URL .'assets/css/style-addons.css', array(), null, 'all'  );} );
		// //Styles
		// add_action( 'elementor/frontend/after_enqueue_styles', function() {  wp_enqueue_style('bim-frontend',BIM_URL .'assets/css/frontend.css', array(), null, 'all'  );} ); 
		
	}

	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		require __DIR__ . '/widgets/slider/dsc-slider.php';
		require __DIR__ . '/widgets/logo.php';
		require __DIR__ . '/widgets/menu.php';
		require __DIR__ . '/widgets/menu-float.php';
		require __DIR__ . '/widgets/header-search.php';
		require __DIR__ . '/widgets/portfolio.php';
		require __DIR__ . '/widgets/product.php';
		require __DIR__ . '/widgets/title.php';
		require __DIR__ . '/widgets/countdown.php';
		require __DIR__ . '/widgets/team/team.php';
		require __DIR__ . '/widgets/fancy/fancy.php';
		require __DIR__ . '/widgets/testimonial.php';
		require __DIR__ . '/widgets/text-icon.php';
		require __DIR__ . '/widgets/image-box.php';
		require __DIR__ . '/widgets/work-process.php';
		require __DIR__ . '/widgets/image-box-slider/imagebox-slider.php';
		require __DIR__ . '/widgets/image-comparison-slider.php';
		require __DIR__ . '/widgets/featured.php';
		require __DIR__ . '/widgets/post-one.php';
		require __DIR__ . '/widgets/post-two.php';
		require __DIR__ . '/widgets/post-three.php';
		require __DIR__ . '/widgets/contact.php';
		require __DIR__ . '/widgets/offcanvas.php';

		
	}
	

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {
		\Elementor\Plugin::instance()->widgets_manager->register( new Dsc_Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Logo() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Menu() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Menu_Float() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Header_Search() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Portfolio() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Product() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Title() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Countdown() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Team() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Fancy() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Testimonial() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_TextIcon() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_ImageBox() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_WorkProcess() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_ImageBoxSlider() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_ImageComparisonSlider() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Featured() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Post() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Post_two() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Post_three() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Contact() );
		\Elementor\Plugin::instance()->widgets_manager->register( new Bim_Offcanvas() );
		
	}
}

new BimPlugin();



